# Working directory on Pedro/Arun's Dropbox for JakStat tolerance manuscript ---------------

setwd("~/Dropbox/Lab people/Data & codes for publications/JakStat tol MS_data & code")


## survival, hazard ratio & bacterial load for fly lines with loss-of-function in JakStat pathway components following P.entomophila 0.05 OD systemic inf (Fig 1)------------

## (A) survival

kmtest <- read.csv("JakStat_SurvivalPI.csv")
str(kmtest) 
library(survminer)
library(survival)
library(magrittr)
surv_fit(Surv(hpi, censor) ~ treatment+flyline, 
         data = kmtest, group.by = "sex") %>%
  ggsurvplot(ggtheme = theme_test(),
             xlab = "Lifespan (hours)", 
             ylab = "Proportion surviving",
             palette = c("slateblue3","indianred3","goldenrod","plum3","black",
                         "slateblue3","indianred3","goldenrod","plum3","black"),
             linetype = c("dotted","dotted","dotted","dotted","dotted",
                          "solid","solid","solid","solid","dashed"),
             pval = FALSE,
             conf.int = FALSE,
             main = "Survival curve",
             font.main = 17,
             font.x =  18,
             font.y = 18,
             font.tickslab = 15,
             size = 1.5
  ) %>%
  purrr::map(function(ggsurv) {ggsurv$plot}) %>%
  ggpubr::ggarrange(plotlist = .)


## (B) hazard function

read.csv("JakStat_riskratio.csv")
hazfn <- read.csv("JakStat_riskratio.csv")
str(hazfn) 
summary(hazfn) 
library(ggplot2)
ggplot(data = hazfn) +
  aes(x = sex, fill = flyline, weight = estimate) +
  geom_bar(position = "dodge") +
  labs(x = "sex",
       y = "Hazard ratio (w1118 vs. gut-epithelial mutants)") +
  theme_test()
p<- ggplot(hazfn, aes(x=sex, y=estimate, fill=flyline)) + 
  geom_bar(stat="identity", color="black",   
           position=position_dodge()) +
  geom_errorbar(aes(ymin=estimate-std_err, ymax=estimate+std_err), width=.2,
                position=position_dodge(.9)) 
print(p)
# Finished bar plot
p+labs(x="Sex", y = "Hazard ratio
       (Jak/Stat mutants/ w1118 flies)")+
  facet_grid(cols = vars(flyline))+
  scale_fill_manual(values = c("indianred3","slateblue3","goldenrod","plum3"))+
  theme_classic(base_size = 24)



## (C) bacterial load

loadall <- read.csv("JakStat_cfus.csv")
str(loadall) 
library(ggplot2)
ggplot(data = loadall) +
  aes(x = flyline, y = log10cfu, fill = flyline) +
  geom_boxplot(alpha=0.5,
               aes(fill=flyline),
               outlier.alpha = 0)+
  labs(x = "Sex",
       y = "Mean bacterial load (log10)") +
  geom_dotplot(position=position_dodge(0.7),
               binaxis='y',
               stackdir='center',
               stackratio=1.5,
               dotsize=1.5,
               binwidth = 0.1,
               aes(fill=flyline)) +
  theme_classic(base_size = 24) +
  scale_fill_manual(values=c("black","indianred3","slateblue3","goldenrod","plum3"))+
  facet_grid(cols=vars(sex))







## impact of loss-of-function in JakStat pathway components on tolerance to P.entomophila 0.05 OD systemic inf (Fig 2)------------

## (A) Tolerance 

pointol=read.csv("JakStat tolerance_non0.csv")
str(pointol)
library(ggpubr)
ggscatter(pointol, x = "log10cfu", y = "mean_hpi",
          add = "reg.line",                       # Add regression line
          conf.int = FALSE,                          # Add confidence interval
          fullrange = FALSE,
          color = "flyline", 
          palette = c("slateblue3","indianred3","goldenrod","plum3","black"),           # Color by groups "cyl"
          shape = "flyline", size = 5,  facet.by = "sex", 
          panel.labs = list(sex = c("Female", "Male")))+         # Change point shape by groups "cyl"
  labs(x = "Mean bacterial load (log10)",
       y = "Average lifespan (hours)")+ 
  theme_pubr(21)



## (B) estimates of linear slope

read.csv("Linear_slope_avg lifespan.csv")
slope <- read.csv("Linear_slope_avg lifespan.csv")
str(slope) 
summary(slope) 
## boxplot
library(ggplot2)
ggplot(data = slope) +
  aes(x = line, fill = line, weight = estimate) +
  geom_bar(position = "dodge") +
  labs(x = "FLy line",
       y = "Linear slope")  +
  theme_test(base_size = 18)+
  facet_grid(cols = vars(sex))
p<- ggplot(slope, aes(x=line, y=estimate, fill=line)) + 
  geom_bar(stat="identity", color="black",  
           position=position_dodge()) +
  geom_errorbar(aes(ymin=estimate-std_err, ymax=estimate+std_err), width=.2,
                position=position_dodge(.9)) + facet_grid(cols = vars(sex))
print(p)
# Finished bar plot
p+labs(x="Fly line", y = "Tolerance Slope 
(estimates from linear reaction norm)")+
  scale_fill_manual(values = c("gray27","indianred3","slateblue3","goldenrod","plum3"))+
  theme_classic(base_size = 22) 








## impact of loss-of-function in G9a - negative regulators of JakStat on survival, load & tolerance to P.entomophila 0.05 OD systemic inf (Fig 3)------------

## (A) G9a survival

kmtest <- read.csv("G9a_survivalPI.csv")
str(kmtest) 
library(survminer)
library(survival)
library(magrittr)
surv_fit(Surv(hpi, censor) ~ treatment+flyline, 
         data = kmtest, group.by = "sex") %>%
  ggsurvplot(ggtheme = theme_test(),
             xlab = "lifespan (hours)", 
             ylab = "proportion surviving",
             palette = c("maroon","steelblue","maroon","steelblue"),
             linetype = c("dotted","dotted","solid","solid"),
             pval = FALSE,
             conf.int = FALSE,
             main = "Survival curve",
             font.main = 17,
             font.x =  18,
             font.y = 18,
             font.tickslab = 15,
             size = 2
  ) %>%
  purrr::map(function(ggsurv) {ggsurv$plot}) %>%
  ggpubr::ggarrange(plotlist = .)




## (B) G9a hazard function

read.csv("G9a_riskratio.csv")
hazfn <- read.csv("G9a_riskratio.csv")
str(hazfn) 
summary(hazfn) 
## boxplot
library(ggplot2)
ggplot(data = hazfn) +
  aes(x = flyline, fill = sex, color = sex, weight = estimate) +
  geom_bar(position = "dodge") +
  labs(x = "Flyline",
       y = "Risk ratio (Jak/Stat mutants vs. y/w)") +
  theme_test()

p<- ggplot(hazfn, aes(x=flyline, y=estimate, fill=sex)) + 
  geom_bar(stat="identity", color="black",  
           position=position_dodge()) +
  geom_errorbar(aes(ymin=estimate-std_err, ymax=estimate+std_err), width=.2,
                position=position_dodge(.9)) 
print(p)
# Finished bar plot
p+labs(x="Flyline", y = "Risk ratio
       (G9a-/- vs. G9a+/+ flies)")+
  scale_fill_manual(values = c("maroon","steelblue"))+
  theme_classic2(base_size = 18)




## (C) G9a load

loadall <- read.csv("G9a_cfus_tolerance.csv")
str(loadall) 
library(ggplot2)
ggplot(data = loadall) +
  aes(x = sex, y = log10cfu, fill = flyline) +
  geom_boxplot(alpha=0.5,
               aes(fill=flyline),
               outlier.alpha = 0)+
  labs(x = "Sex",
       y = "Mean bacterial load (Log10)") +
  geom_dotplot(position=position_dodge(0.75),
               binaxis='y',
               stackdir='center',
               stackratio=1.5,
               dotsize=1.25,
               binwidth = 0.1,
               aes(fill=flyline)) +
  theme_classic(base_size = 24) +
  scale_fill_manual(values=c("steelblue","maroon","steelblue"))+
  facet_grid(cols=vars())


## (D) G9a tolerance

pointol=read.csv("G9a_cfus_tolerance.csv")
str(pointol)
library(ggpubr)
ggscatter(pointol, x = "log10cfu", y = "mean_hpi",
          add = "reg.line",                         # Add regression line
          conf.int = FALSE,                          # Add confidence interval
          color = "flyline", 
          palette = c("steelblue","maroon","goldenrod","plum3","black"),           # Color by groups "cyl"
          shape = "flyline", size = 5,  facet.by = "sex", 
          panel.labs = list(sex = c("Female", "Male")))+         # Change point shape by groups "cyl"
  labs(x = "Mean bacterial load (Log10)",
       y = "Mean lifespan (hours)")+ theme_pubr(20)
+
  stat_cor(aes(color = flyline), label.x = 3) 








## survival - background fly line (yw) vs outcross fly line following P.entomophila 0.05 OD systemic inf (Fig 3)------------

kmtest <- read.csv("Controls_survivalPI.csv")
str(kmtest) 
library(survminer)
library(survival)
library(magrittr)
surv_fit(Surv(hpi, censor) ~ treatment+flyline, 
         data = kmtest, group.by = "sex") %>%
  ggsurvplot(ggtheme = theme_test(),
             xlab = "Lifespan (hours)", 
             ylab = "Proportion surviving",
             palette = c("chocolate3","black","chocolate3","black","grey40",
                         "slateblue3","indianred3","goldenrod","plum3","black"),
             linetype = c("dotted","dotted","solid","solid","dotted",
                          "solid","solid","solid","solid","dashed"),
             pval = FALSE,
             conf.int = FALSE,
             main = "Survival curve",
             font.main = 17,
             font.x =  18,
             font.y = 18,
             font.tickslab = 15,
             size = 2
  ) %>%
  purrr::map(function(ggsurv) {ggsurv$plot}) %>%
  ggpubr::ggarrange(plotlist = .)


######## qPRC confimarion of transgenic lines ###############


# Load packages
library(tidyverse)
library(dplyr)
library(car)
library(lme4)
library(reshape2)
library(RColorBrewer)
library(ggpubr)
library(emmeans)
library(scales)
library(ggbeeswarm)
library(glmmTMB)

# For std error
library(plotrix)
library(MASS)

# for facet_nested_wrap
library(ggh4x)

# for model performance
library(performance)

# Read in file and log2 transform data 
jakstat <- read.csv(file.choose(), header=TRUE)
jakstat$Gene.expression.relative.to.rp49 <- log2(jakstat$Gene.expression.relative.to.rp49)

#Subset data for each gene
totA <- subset(jakstat, Gene == "Tot A")
upd3 <- subset(jakstat, Gene == "UPD3")


# Jitter plot by line, faceted by sex- 
totA_pcr <- ggplot(totA, aes(x=Sample, y=Gene.expression.relative.to.rp49))+
  geom_jitter(aes(x= Sample, y=Gene.expression.relative.to.rp49, color=Sample), alpha=0.8, size=2, width= 0.28, show.legend=FALSE)+ 
  #geom_line(aes(group=paired, color=line))+
  facet_wrap(~Sex)+theme_bw(base_size=13)+
  labs(x="Line", y="Log2 TotA expression relative to rp49")+
  stat_summary(fun = mean, geom = "point", size=4)+
  stat_summary(fun.data = mean_se, geom = "errorbar", width=0.2, linewidth=0.5)+
  theme(strip.background=element_blank()) + theme(panel.grid= element_blank())+ theme(legend.text = element_text(face ="italic"))+
  theme(axis.text.x = element_text(face ="italic"))+ theme(axis.text.x = element_text(angle=45, hjust=1))

totA_pcr


UPD3_pcr <- ggplot(upd3, aes(x=Sample, y=Gene.expression.relative.to.rp49))+
  geom_jitter(aes(x= Sample, y=Gene.expression.relative.to.rp49, color=Sample), alpha=0.8, size=2, width= 0.28, show.legend=FALSE)+ 
  #geom_line(aes(group=paired, color=line))+
  facet_wrap(~Sex)+theme_bw(base_size=13)+
  labs(x="Line", y="Log2 Upd3 expression relative to rp49")+
  stat_summary(fun = mean, geom = "point", size=4)+
  stat_summary(fun.data = mean_se, geom = "errorbar", width=0.2, size=0.5)+
  theme(strip.background=element_blank()) + theme(panel.grid= element_blank())+ theme(legend.text = element_text(face ="italic"))+
  theme(axis.text.x = element_text(face ="italic"))+ theme(axis.text.x = element_text(angle=45, hjust=1))



UPD3_pcr


library(patchwork)

totA_pcr / UPD3_pcr

#############################
#    Analysis!!!           ##
#############################

# Relevel lines for comparison against yw
str(jakstat)
totA$Sample <- as.factor(totA$Sample)
totA$Sample <- relevel(totA$Sample, ref = "Y,W")
upd3$Sample <- as.factor(upd3$Sample)
upd3$Sample <- relevel(upd3$Sample, ref = "Y,W")

totA_lm <- lm(Gene.expression.relative.to.rp49~Sample*Sex, data=totA)
names(totA_lm)
par(mfrow = c(2,2))
plot(totA_lm)
anova(totA_lm) %>% as.data.frame() %>% write.csv(file = "totA_anova_table.csv")
summary(totA_lm)
contrastsTotA <- as.data.frame(emmeans(totA_lm, pairwise ~Sample:Sex)$contrasts)


upd3_lm <- lm(Gene.expression.relative.to.rp49~Sample*Sex, data=upd3)
names(upd3_lm)
par(mfrow = c(2,2))
plot(upd3_lm)
anova(upd3_lm) %>% as.data.frame() %>% write.csv(file = "upd3_anova_table.csv")
summary(upd3_lm)


